// Gmsh project created on Wed Mar 08 19:04:01 2023

// Variables pertaining to the study
L = 150;
lambda = 4;
gamma = lambda * L;
alpha = 0.3;
A = alpha * L;
PointsOnSine = 200;

//Meshing Variables
F = 1200;
G = Ceil(F/70);

//+
Point(1) = {0, 0, -0, 1.0};
Point(2) = {0, 1.5*L, -0, 1.0};
Point(3) = {0, -1.5*L, -0, 1.0};
Point(4) = {L, 1.5*L, -0, 1.0};
Point(5) = {L, -1.5*L, -0, 1.0};
Point(6) = {L, L, -0, 1.0};
Point(7) = {L, -L, -0, 1.0};


//+
Line(3) = {3, 5};
Line(4) = {2, 4};
Line(5) = {4, 6};
Line(6) = {5, 7};

// Top sinusoidal modelling

p1List[0] = 6; // First point label
    nPoints = 200; // Number of discretization points (top-right point of the inlet region)
	For i In {1 : nPoints}
	  x = L + (80*L)*i/(nPoints + 1);
	  p1List[i] = newp;
	  Point(p1List[i]) = {x,
	                (L + A*Sin(2*Pi*(x-L)/gamma)),
	                0,
	                0};
	EndFor
    Point(newp) = {L + gamma*5, L, 0, 1.0};
	p1List[nPoints+1] = 207; // Last point label (top-left point of the outlet region)
 
	Spline(newl) = p1List[];


// Bottom sinusoidal modelling

p2List[0] = 7; // First point label
	nPoints= 200; // Number of discretization points (top-right point of the inlet region)
	For i In {1 : nPoints}
	  x = L + (80*L)*i/(nPoints + 1);
	  p2List[i] = newp;
	  Point(p2List[i]) = {x,
	                (-L + A*Sin(2*Pi*(x-L)/gamma)),
	                0,
	                0};
	EndFor
    Point(newp) = {L + gamma*5, -L, 0, 1.0};
	p2List[nPoints+1] = 408; // Last point label (top-left point of the outlet region)
 
	Spline(newl) = p2List[];
    
//+
Point(410) = {0, 150, 0, 1.0};
//+
Point(411) = {0, -150, 0, 1.0};
//+
Line(11) = {410, 6};
//+
Line(12) = {411, 7};
//+
Line(13) = {2, 410};
//+
Line(15) = {411, 3};
Point(413) = {150, 0, 0, 1.0};

p3List[0] = 413; // First point label
	nPoints= 200; // Number of discretization points (top-right point of the inlet region)
	For i In {1 : nPoints}
	  x = L + (80*L)*i/(nPoints + 1);
	  p3List[i] = newp;
	  Point(p3List[i]) = {x,
	                (A*Sin(2*Pi*(x-L)/gamma)),
	                0,
	                0};
	EndFor
    Point(newp) = {L + gamma*5, -L, 0, 1.0};
	p3List[nPoints+1] = 613; // Last point label (top-left point of the outlet region)
 
	Spline(newl) = p3List[];

//+
Line(17) = {1, 410};
//+
Line(18) = {413, 6};
//+
Line(19) = {1, 411};
//+
Line(20) = {413, 7};
//+
Line(21) = {613, 207};
//+
Line(22) = {613, 408};
Line(23) = {1, 413};
Transfinite Curve {7, 16, 8} = F Using Progression 1;
//+
Transfinite Curve {18, 17, 21} = Ceil(F*2/120) Using Progression 1;
//+
Transfinite Curve {22, 20, 19} = Ceil(F*2/120) Using Progression 1;
//+
Transfinite Curve {12, 11, 4, 3, 23} = G Using Progression 1;
//+
Transfinite Curve {13, 13, 5, 15, 15, 6} = Ceil(0.5*G) Using Progression 1;
//+
Curve Loop(1) = {11, -5, -4, 13};
//+
Plane Surface(1) = {1};
//+
Curve Loop(2) = {23, 18, -11, -17};
//+
Plane Surface(2) = {2};
//+
Curve Loop(3) = {19, 12, -20, -23};
//+
Plane Surface(3) = {3};
//+
Curve Loop(4) = {3, 6, -12, 15};
//+
Plane Surface(4) = {4};
//+
Curve Loop(5) = {8, -22, -16, 20};
//+
Plane Surface(5) = {5};
//+
Curve Loop(6) = {16, 21, -7, -18};
//+
Plane Surface(6) = {6};
Transfinite Surface {1,2,3,4,5,6};
Recombine Surface {1,2,3,4,5,6};

Extrude {0,0,50} {
	  Surface{1,2,3,4,5,6}; Layers{1}; Recombine;
	}//+

Physical Surface("inlet2") = {98};
//+
Physical Surface("inlet1") = {40};
//+
Physical Surface("FrontandBack") = {45, 2, 1, 67, 89, 111, 4, 3, 133, 6, 155, 5};
//+
Physical Surface("outlet") = {146, 124};
Physical Surface("FixedWalls") = {150, 120, 66, 76, 44, 36, 102, 110};
Physical Volume("internal")= {1,2,3,4,5,6};
//+
